require 'directory_generator'

Dir.class_eval do
  def self.diff(d1,d2)
    recursive_diff(dfs_gen(d1),dfs_gen(d2),d1,d2,"")
  end
  
  private 
  def self.recursive_diff(g1,g2,p1,p2,indent)
    puts "#{indent}diffing #{p1} and #{p2}"
    g1_val, g2_val = g1.resume, g2.resume()
    while not(g1_val == :done or g2_val == :done) do
      if (g1_val == g2_val)
        recursive_diff(g1,g2,p1+'/'+g1_val.name,p2+'/'+g2_val.name,indent+"    ") if g1_val.is_directory
        g1_val,g2_val = g1.resume,g2.resume
      else
        if (g1_val < g2_val)
          print(:gen => g1,:path => p1+'/'+g1_val.name, :file => g1_val, :prefix => "#{indent}<<<")
          g1_val = g1.resume
        elsif (g2_val < g1_val)
          print(:gen => g2, :path => p2+'/'+g2_val.name, :file => g2_val,:prefix => "#{indent}>>>")
          g2_val = g2.resume
        else
          puts "#{indent} ! #{p1}/#{g1_val.name} and #{p2}/#{g2_val.name} are distinct types..."
          g1_val,g2_val = g1.resume,g2.resume
        end
      end
    end
    if not g2_val == :done then
      print({ :gen => g2, :path => p2+'/'+g2_val.name,:file => g2_val, :prefix => "#{indent}>>>"})
    elsif not g1_val == :done
      print({ :gen => g1, :path => p1+'/'+g1_val.name, :file => g1_val, :prefix => "#{indent}<<<"})
    end
    puts "#{indent}FINISHED diffing #{p1} and #{p2}"
  end
  
  def self.print conf
    if conf[:file].is_directory
      puts "#{conf[:prefix]}dir: #{conf[:path]}"
      conf[:prefix] = "    #{conf[:prefix]}"
      while not((d = conf[:gen].resume) == :done)
        if (d.is_directory)
          print({:gen => conf[:gen], :path => conf[:path]+'/'+d.name,
            :file => d,:prefix => conf[:prefix]})            
        else
          puts "#{conf[:prefix]}#{d.name}"
        end
      end
    else
      puts "#{conf[:prefix]}#{conf[:path]}"
    end
  end
end