class FileResult < Struct.new(:name,:is_directory)
  def <(other)
    name < other.name
  end
end

Dir.class_eval do
  def self.dfs_gen d
    Fiber.new do 
      co_diff d, nil
    end
  end
  
  def self.co_diff d, other
    open(d) do |dir|
      dir.entries.delete_if {|dd| dd == '.' || dd == '..'}.sort.each do |file|
        entry = d+'/'+file
        is_dir = Dir.exist?(entry)
        if other.nil?
          other = Fiber.yield(FileResult.new(file,is_dir))
        elsif other == :done
          
        else
          
        end
        process_dir entry if is_dir
      end
    end
    Fiber.yield :done 
  end
end
