﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using ImdbCmd;
using Microsoft.Practices.Unity;

namespace ImdbWeb.Controllers
{
    [HandleError]
    public class HomeController : Controller
    {
        public ActionResult Index()
        {
            var result = MovieRepository
                .FindLongBruceWillisMovies()
                .Select(movie => movie.Title);

            ViewData.Model = result;

            return View();
        }

        public ActionResult About()
        {
            return View();
        }

        [Dependency]
        public MovieRepository MovieRepository { get; set; }
    }
}
