﻿using System;
using System.Collections.Generic;
using System.Configuration;
using System.Linq;
using System.Text;
using Microsoft.Practices.Unity;
using Microsoft.Practices.Unity.Configuration;

namespace ImdbCmd
{
    class Program
    {
        static void Main(string[] args)
        {
            var container = new UnityContainer();
            var section = (UnityConfigurationSection)ConfigurationManager.GetSection("unity");
            section.Containers["imdbContainer"].Configure(container);

            var repository = container.Resolve<MovieRepository>();

            foreach (var movie in repository.FindLongBruceWillisMovies())
            {
                Console.WriteLine("{0} ({1})", movie.Title, movie.Length);
            }

            Console.ReadLine();
        }
    }
}
