using System.Web.Mvc;
using Microsoft.Practices.Unity;

namespace ImdbWeb
{
    public class UnityControllerFactory : DefaultControllerFactory
    {
        private readonly UnityContainer _container;

        public UnityControllerFactory(UnityContainer container)
        {
            _container = container;
        }

        protected override IController GetControllerInstance(System.Type controllerType)
        {
            if (controllerType == null) return null;

            return _container.Resolve(controllerType) as IController;
        }
    }
}