﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using ImdbCmd;
using NUnit.Framework;
using Rhino.Mocks;

namespace ImdbCmdTests
{
    [TestFixture]
    public class MovieRepositoryTests
    {
        [Test]
        public void FindLongBruceWillisMoviesTest()
        {
            // Arrange
            var mockRepository = new MockRepository();

            var context = mockRepository.DynamicMock<IModelDataContext>();

            var movie1 = new Movie {Title = "Twelve Monkeys", LeadRole = "Bruce Willis", Length = 121};
            var movie2 = new Movie {LeadRole = "Bruce Willis", Length = 120};
            var movie3 = new Movie {LeadRole = "Bruce Willis", Length = 119};
            var movie4 = new Movie {LeadRole = "Client Eastwood", Length = 121};
            var movie5 = new Movie {LeadRole = "", Length = 0};
            context.Expect(c => c.FindAll<Movie>()).Return(new[] {movie1, movie2, movie3, movie4, movie5}.AsQueryable());

            var repository = new MovieRepository(context);

            mockRepository.ReplayAll();

            // Act
            var result = repository.FindLongBruceWillisMovies();

            // Assert
            Assert.That(result.Count(), Is.EqualTo(1));
            Assert.That(result.First().Title, Is.EqualTo("Twelve Monkeys"));
        }
    }
}
